{********************************************
; File: NoteSyn.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT NOTESYN;
INTERFACE
USES TYPES;
CONST


{ Error Codes }
nsAlreadyInit = $1901;  { Note Syn already initialized }
nsSndNotInit = $1902;  { Sound Tools not initialized }
nsNotAvail = $1921;  { generator not available }
nsBadGenNum = $1922;  { bad generator number }
nsNotInit = $1923;  { Note Syn not initialized }
nsGenAlreadyOn = $1924;  { generator already on }
soundWrongVer = $1925;  { incompatible versions of Sound  and NoteSyn }
TYPE
EnvelopeHndl = ^EnvelopePtr;
EnvelopePtr = ^Envelope;
Envelope = PACKED RECORD
    st1BkPt : Byte;
    st1Increment : Integer;
    st2BkPt : Byte;
    st2Increment : Integer;
    st3BkPt : Byte;
    st3Increment : Integer;
    st4BkPt : Byte;
    st4Increment : Integer;
    st5BkPt : Byte;
    st5Increment : Integer;
    st6BkPt : Byte;
    st6Increment : Integer;
    st7BkPt : Byte;
    st7Increment : Integer;
    st8BkPt : Byte;
    st8Increment : Integer;
END;
WaveFormHndl = ^WaveFormPtr;
WaveFormPtr = ^WaveForm;
WaveForm = PACKED RECORD
    wfTopKey : Byte;
    wfWaveAddress : Byte;
    wfWaveSize : Byte;
    wfDocMode : Byte;
    wfRelPitch : Integer;
END;
InstrumentHndl = ^InstrumentPtr;
InstrumentPtr = ^Instrument;
Instrument = PACKED RECORD
    theEnvelope : Envelope;
    releaseSegment : Byte;
    priorityIncrement : Byte;
    pitchBendRange : Byte;
    vibratoDepth : Byte;
    vibratoSpeed : Byte;
    inSpare : Byte;
    aWaveCount : Byte;
    bWaveCount : Byte;
    aWaveList : ARRAY[1..1] OF WaveForm;
    bWaveList : ARRAY[1..1] OF WaveForm;
END;
PROCEDURE AllNotesOff   ;
FUNCTION AllocGen ( requestPriority:Integer) : Integer ;
PROCEDURE DeallocGen ( genNumber:Integer)  ;
PROCEDURE NoteOff ( genNumber:Integer; semitone:Integer)  ;
PROCEDURE NoteOn ( genNumber:Integer; semitone:Integer; volume:Integer; instrumentPtr:Ptr)  ;
PROCEDURE NSBootInit   ;
PROCEDURE NSReset   ;
FUNCTION  NSSetUpdateRate ( updateRate:Integer) : Integer ;
{ zero defaults to 500 }
FUNCTION NSSetUserUpdateRtn ( updateRtn:VoidProcPtr) : VoidProcPtr ;
PROCEDURE NSShutDown   ;
PROCEDURE NSStartUp ( updateRate:Integer; userUpdateRtnPtr:Ptr)  ;
FUNCTION NSStatus  : Boolean ;
FUNCTION NSVersion  : Integer ;
IMPLEMENTATION
END.
